VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DlxOCX32.ocx"
Begin VB.Form Form1 
   Caption         =   "High Speed Digital Input Feature of KPCI3100 Driver"
   ClientHeight    =   5235
   ClientLeft      =   1995
   ClientTop       =   1710
   ClientWidth     =   7860
   LinkTopic       =   "Form1"
   ScaleHeight     =   5235
   ScaleWidth      =   7860
   Begin VB.ComboBox devNum 
      Height          =   315
      Left            =   3000
      TabIndex        =   7
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   1080
      Width           =   615
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Initialize"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   480
      TabIndex        =   6
      Top             =   960
      Width           =   2175
   End
   Begin VB.ListBox lstPortB 
      Height          =   2400
      Left            =   5160
      TabIndex        =   3
      Top             =   1320
      Width           =   855
   End
   Begin VB.ListBox lstPortA 
      Height          =   2400
      Left            =   6240
      TabIndex        =   2
      Top             =   1320
      Width           =   855
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start"
      Enabled         =   0   'False
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   480
      TabIndex        =   1
      Top             =   1680
      Width           =   2175
   End
   Begin DlsrLib.DriverLINXSR DriverLINXSR1 
      Left            =   3120
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.Label Label5 
      Caption         =   $"HSpeedDig.frx":0000
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   1455
      Left            =   360
      TabIndex        =   10
      Top             =   3360
      Width           =   4335
   End
   Begin VB.Label Label4 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   18
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H00FFFFFF&
      Height          =   435
      Left            =   480
      TabIndex        =   9
      Top             =   240
      Width           =   2295
   End
   Begin VB.Label Label3 
      Caption         =   "Device Number :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   3000
      TabIndex        =   8
      Top             =   840
      Width           =   1455
   End
   Begin VB.Label Label2 
      Caption         =   "Port B Data"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   5040
      TabIndex        =   5
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "Port A Data"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   6240
      TabIndex        =   4
      Top             =   1080
      Width           =   975
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Status"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   360
      TabIndex        =   0
      Top             =   2520
      Width           =   4095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
' always use above to force variable declaration!!!!!
' tested with 3100-850A03 in Win2K SP1 with KPCI-3104 hardware
'
' high speed digital feature of KPCI-3100 Series is accessed through the
' AI subsystem of the board.  To indicate the channel of interest is the digital
' channel, use channel 0 with a special gain code (8192).  This digital channel
' is always 16bits wide comprised of ports A and B.


Private Sub cmdInit_Click()
'open the driver
DriverLINXSR1.Req_DLL_name = "kpci3100$"  ' load only the driver for kpci3100
' this applies to 6 boards:  KPCI-3101,KPCI-3102,KPCI-3103,KPCI-3104,KPCI-3110,KPCI-3116

' init the hardware
With DriverLINXSR1
.Req_device = devNum            ' from the combo box
.Req_mode = DL_OTHER
.Req_subsystem = DL_DEVICE  ' init entire device
.Req_op = DL_INITIALIZE
.Refresh
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
lblStatus.Caption = "Initialized without error...push Start Button"
cmdStart.Enabled = True
cmdInit.Enabled = False
Else
' display error message
lblStatus.Caption = DriverLINXSR1.Message
End If
End Sub

Private Sub cmdStart_Click()
lstPortA.Clear  ' clear list boxes
lstPortB.Clear
With DriverLINXSR1
.Req_subsystem = DL_AI  ' use AI subsystem for access to hardware FIFO
.Req_mode = DL_DMA
.Req_op = DL_START      ' this is start operation
.Evt_Str_type = DL_COMMAND  ' start on software command, eg, when .Refresh is called
.Evt_Stp_type = DL_TCEVENT  ' stop when buffer is full
' specify the speed of the data capture
.Evt_Tim_type = DL_RATEEVENT
.Evt_Tim_rateChannel = DL_DEFAULTTIMER
.Evt_Tim_rateMode = DL_RATEGEN
.Evt_Tim_rateClock = DL_INTERNAL1  ' or change to DL_EXTERNAL for external clock
.Evt_Tim_rateGate = DL_DISABLED
' below line tells DriverLINX the rate of the clock is 10000 Hz
.Evt_Tim_ratePeriod = .DLSecs2Tics(DL_DEFAULTTIMER, 1 / 10000)
' ********  Select Group ***************
.Sel_chan_format = DL_tNATIVE
.Sel_chan_N = 1  ' a single channel
.Sel_chan_start = 0  ' channel 0 can be analog or digital depending on GainCode
.Sel_chan_startGainCode = 2 ^ 13  ' gain code of 8192 with chan 0 means digital channel
.Sel_buf_N = 1   ' one buffer
.Sel_buf_samples = 20000   ' how many 16bit samples (Port A + Port B = 16bits)
.Sel_buf_notify = DL_NOTIFY  ' send buffer filled message
.Refresh  ' do it
End With
If DriverLINXSR1.Res_result = DL_NoErr Then
' if no error, prompt for the trigger
lblStatus.Caption = "task is started....."
Else
' display error message
lblStatus.Caption = DriverLINXSR1.Message  ' display status
End If


End Sub

Private Sub DriverLINXSR1_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
' program execution comes here automatically when DLinx sends the buffer is full
' message to this application

'update status label
lblStatus.Caption = "Data has arrived...."
Beep
Dim i As Integer
Dim dummy As Single
Dim DigData(40000) As Byte  ' declare a byte array for our data 2*SampleSize
dummy = DriverLINXSR1.VBArrayBufferXfer(bufIndex, DigData, DL_BufferToVBArray)
' each buffer element is 16bits wide so contains sample from Port A and Port B
' the BufferXfer method moves this to an array (DigData) of type byte.  The data
' in this array will alternate from port A, port B, port A, port B, etc.

' display some of the data
For i = 0 To 19 Step 2
lstPortA.AddItem DigData(i)
lstPortB.AddItem DigData(i + 1)
Next i

End Sub

Private Sub Form_Load()
' populate devNum combo box with legal values for device number
Dim i As Integer
For i = 0 To 5
devNum.AddItem Str(i), i
Next i
' set combo box equal to first entry
devNum.ListIndex = 0

End Sub


Private Sub Form_Unload(Cancel As Integer)
' place the clean up code here
' stop any active task
DriverLINXSR1.Req_op = DL_STOP
DriverLINXSR1.Refresh
' unload the driver from memory
DriverLINXSR1.Req_DLL_name = "" 'no space
'unload the driver
End Sub

